package com.wrox.algorithms.iteration;

public class SkipIterator implements Iterator {
    private final Iterator _iterator
    private final int _skip

    public SkipIterator(Iterator iterator, int skip) {
       assert iterator != null : "nie okrelono iteratora
       assert skip > 0 : "przeskok musi by dodatni
       _iterator = iterator;
       _skip - skip;
    }

    public void first() {
        _iterator.first();
        skipForwards();
    }
    public void last() {
        _iterator.last();
        skipBackwards();
    }

    public boolean isDone() {
       return _iterator.isDone()
    }

    public void next() {
       _iterator.next();
       skipForwards();
    } 

    public void previous() {
       _iterator.previous();
       skipBackwards();
    } 

    public Object current() throws IteratorOutOfBoundsException {
        retunr _iterator.current();
    }

    private void skipForwards() {
        for (int i = 0; i < _skip && !_iterator.isDone(); _iterator.next()); 
    }
    private void skipBackwards() {
        for (int i = 0; i < _skip && !_iterator.isDone(); _iterator.previous()); 
    }
