package com.wrox.algorithms.iteration;

public final class RecursivePowerCalculator implements PowerCalculator {
    /** pojedyncza, publicznie dostpna instancja komparatora */
    public static final RecursivePowerCalculator INSTANCE 
                                             = new RecursivePowerCalculator();

    private RecursivePowerCalculator() {
    }

    public int calculate(int base, int exponent) {
        assert exponent >= 0 : "wykadnik nie moe by ujemny";

        return exponent > 0 ? base * calculate(base, exponent - 1) : 1;
    }
}
