package com.wrox.algorithms.iteration;

import java.io.File;

public final class RecursiveDirectoryTreePrinter {
    /** cig spacji oznaczajcy pojedyncze wcicie */
    private static final String SPACES = "  ";





    private RecursiveDirectoryTreePrinter() {
    }




    /**
     * Parametr wywoania: nazwa katalogu
     */


    public static void main(String[] args) {
        assert args != null : "nie podano nazwy katalogu";

        if (args.length != 1) {
            System.err.println("Wywoanie: RecursiveDirectoryTreePrinter <katalog>");
            System.exit(-1);
        }

        print(new File(args[0]), "");
    }


    public static void print(File file, String indent) {
        assert file != null : "nie okrelono obiektu File";
        assert indent != null : "nie okrelono wcicia";

        System.out.print(indent);
        System.out.println(file.getName());

        if (file.isDirectory()) {
            print(file.listFiles(), indent + SPACES);
        }
    }

    public static void print(File[] files, String indent) {
    assert files != null: "Nie okrelono listy plikw";

    for (int i = 0; i < files.length; ++i)  {
        print(files[i], indent);
    }



    private static void print(Iterator files, String indent) {
        assert files != null : "Nie okrelono iteratora plikw";

        for (files.first(); !files.isDone(); files.next()) {
            print((File) files.current(), indent);
        }
    }





}
