package com.wrox.algorithms.iteration;

/**
 * Iterator bazujcy na wzorcach projektowych (Gamma i in. 1995).
 */
public interface Iterator {
    /**
     * (Re)pozycjonuje iterator na pierwszym elemencie.
     * Gdy niezaimplementowana, wywouje wyjtek UnsupportedOperationException
     */
    public void first();

    /**
     * (Re)pozycjonuje iterator na ostatnim elemencie.
     * Gdy niezaimplementowana, wywouje wyjtek UnsupportedOperationException
     */
    public void last();

    /**
     * Sprawdza, czy okrelony jest biecy element iteracji
     * zwraca false gdy jest i true, gdy nie jest
     */
    public boolean isDone();

    /**
     * Pozycjonuje iterator na nastpnym elemencie.
     * Gdy niezaimplementowana, wywouje wyjtek UnsupportedOperationException
     */
    public void next();

    /**
     * Pozycjonuje iterator na poprzednim elemencie.
     * Gdy niezaimplementowana, wywouje wyjtek UnsupportedOperationException
     */
    public void previous();

    /**
     * Zwraca warto biecego elementu;.
     * Gdy biecy element nie jest okrelony, wywouje wyjtek 
     * IteratorOutOfBoundsException
     */
    public Object current() throws IteratorOutOfBoundsException;
}
