package com.wrox.algorithms.iteration;


public final class IterativePowerCalculator implements PowerCalculator {

    /** Pojedyncza, publicznie dostpna instancja komparatora */
    public static final IterativePowerCalculator INSTANCE = new IterativePowerCalculator();

    
    private IterativePowerCalculator() {
    }

    public int calculate(int base, int exponent) {
        assert exponent >= 0 : "wykadnik nie moe by ujemny";

        int result = 1;

        for (int i = 0; i < exponent; ++i) {
            result *= base;
        }

        return result;
    }
}
