package com.wrox.algorithms.iteration;

public class ArrayIterator implements Iterator {
    /** Tablica, po ktrej iterator nawiguje */
    private final Object[] _array;

    /** Indeks pierwszego elementu wycinka */
    private final int _first;

    /* Indeks ostatniego elementu wycinka */
    private final int _last;

    /** Indeks biecego elementu */
    private int _current = -1;

    /**
     * Konstruktor specyfikujcy wycinek tablicy
     * parametrami s: tablica, indeks pierwszego elementu i liczba elementw
    */

    public ArrayIterator(Object[] array, int start, int length) {
        assert array != null : "nie okrelono tablicy";
        assert start >= 0 : "ujemny indeks elementu pocztkowego";
        assert start < array.length : "indeks elementu pocztkowego poza tablic";
        assert length >= 0 : "ujemna liczba elementw";

        _array = array;
        _first = start;
        _last = start + length - 1;

        assert _last < array.length : "wycinek wykracza poza tablic";
    }

    /**
     * Konstruktor specyfikujcy ca tablic
     */

    public ArrayIterator(Object[] array) {
        assert array != null : "nie okrelono tablicy";
        _array = array;
        _first = 0;
        _last = array.length - 1;
    }

    public void first() {
        _current = _first;
    }

    public void last() {
        _current = _last;
    }
    

    public void next() {
        ++_current;
    }

    public void previous() {
        --_current;
    }


    public boolean isDone() {
        return _current < _first || _current > _last;
    }


    public Object current() throws IteratorOutOfBoundsException {
        if (isDone()) {
            throw new IteratorOutOfBoundsException();
        }
        return _array[_current];
    }


}
