package com.wrox.algorithms.hashing;

public final class SimplePrimeNumberGenerator implements PrimeNumberGenerator {
    /** pojedyncza instancja klasy */
    public static final SimplePrimeNumberGenerator INSTANCE = 
                                              new SimplePrimeNumberGenerator();

    private SimplePrimeNumberGenerator() {
    }

    public int generate(int candidate) {
        int prime = candidate;

        while (!isPrime(prime)) {
            ++prime;
        }

        return prime;
    }

    
    private boolean isPrime(int candidate) {
        for (int i = candidate / 2; i >= 2; --i) {
            if (candidate % i == 0) {
                return false;
            }
        }
        return true;
    }
}
