package com.wrox.algorithms.bsearch;

import com.wrox.algorithms.iteration.Iterator;
import com.wrox.algorithms.lists.List;
import com.wrox.algorithms.sorting.Comparator;

public class LinearListSearcher implements ListSearcher {
    /**  komparator wyznaczajcy porzdek porwnywanych elementw */
    private final Comparator _comparator;

    /**
     * Konstruktor.
     * Parametr: komparator wyznaczajcy porzdek porwnywanych elementw
     */
    public LinearListSearcher(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";
        _comparator = comparator;
    }

    public int search(List list, Object key) {
        assert list != null : "nie okrelono listy";

        int index = 0;
        Iterator i = list.iterator();

        for (i.first(); !i.isDone(); i.next()) {
            int cmp = _comparator.compare(key, i.current());
            if (cmp == 0) {
                return index;
            } else if (cmp < 0) {
                break;
            }

            ++index;
        }

        return -(index + 1);
    }
}
