package com.wrox.algorithms.sorting;

import com.wrox.algorithms.lists.ArrayList;
import com.wrox.algorithms.lists.List;
import junit.framework.TestCase;

public class ListSorterCallCountingTest extends TestCase {
    private static final int TEST_SIZE = 1000;

    // lista posortowana
    private final List _sortedArrayList = new ArrayList(TEST_SIZE);

    // lista posortowana odwrotnie
    private final List _reverseArrayList = new ArrayList(TEST_SIZE);

    // lista o przypadkowej kolejnoci elementw 
    private final List _randomArrayList = new ArrayList(TEST_SIZE);

    private CallCountingComparator _comparator;


    protected void setUp() throws Exception {
        super.setUp();
        _comparator = new CallCountingComparator(NaturalComparator.INSTANCE);

        for (int i = 1; i < TEST_SIZE; ++i) {
            _sortedArrayList.add(new Integer(i));
        }

        for (int i = TEST_SIZE; i > 0; --i) {
            _reverseArrayList.add(new Integer(i));
        }

        for (int i = 1; i < TEST_SIZE; ++i) {
            _randomArrayList.add(new Integer((int)(TEST_SIZE * Math.random())));
        }
    }


    public void testReverseCaseBubblesort () {
        new BubblesortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }

    public void testReverseCaseSelectionSort () {
        new SelectionSortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }

    public void testReverseCaseInsertionSort () {
        new InsertionSortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }




    public void testDirectCaseBubblesort () {
        new BubblesortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }

    public void testDirectCaseSelectionSort () {
        new SelectionSortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }

    public void testDirectCaseInsertionSort () {
        new InsertionSortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }





    public void testRandomCaseBubblesort () {
        new BubblesortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }

    public void testRandomCaseSelectionSort () {
        new SelectionSortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }

    public void testRandomCaseInsertionSort () {
        new InsertionSortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }




    public void testReverseCaseShellsort () {
        new ShellsortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }

    public void testReverseCaseQuicksort () {
        new QuicksortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }

    public void testReverseCaseMergesort () {
        new MergesortListSorter(_comparator).sort(_reverseArrayList);
        reportCalls();
    }




    public void testDirectCaseShellsort () {
        new ShellsortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }

    public void testDirectCaseQuicksort () {
        new QuicksortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }

    public void testDirectCaseMergesort () {
        new MergesortListSorter(_comparator).sort(_sortedArrayList);
        reportCalls();
    }



    public void testRandomCaseShellsort () {
        new ShellsortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }

    public void testRandomCaseQuicksort () {
        new QuicksortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }

    public void testRandomCaseMergeSort () {
        new MergesortListSorter(_comparator).sort(_randomArrayList);
        reportCalls();
    }



    private void reportCalls() {
        System.out.println(getName() + ": " + _comparator.getCallCount() + " wywoa");
    }


}
