package com.wrox.algorithms.ssearch;

import com.wrox.algorithms.iteration.Iterator;
import com.wrox.algorithms.iteration.IteratorOutOfBoundsException;

public class StringMatchIterator implements Iterator {
    /** wyszukiwarka */
    private final StringSearcher _searcher;

    /** przeszukiwany tekst */
    private final CharSequence _text;

    /** informacja na temat ostatniego wystpienia wzorca */
    private StringMatch _current;

    public StringMatchIterator(StringSearcher searcher, CharSequence text) {
        assert searcher != null : "nie okrelono wyszukiwarki";
        assert text != null : "nie okrelono tekstu do przeszukiwania";

        _searcher = searcher;
        _text = text;
    }

    public void first() {
        _current = _searcher.search(_text, 0);
    }

    public void last() {
        throw new UnsupportedOperationException();
    }

    public boolean isDone() {
        return _current == null;
    }

    public void next() {
        if (!isDone()) {
            _current = _searcher.search(_text, _current.getIndex() + 1);
        }
    }

    public void previous() {
        throw new UnsupportedOperationException();
    }

    public Object current() throws IteratorOutOfBoundsException {
        if (isDone()) {
            throw new IteratorOutOfBoundsException();
        }
        return _current;
    }
}
