public class SelectionSortListSorter implements ListSorter {
    private final Comparator _comparator;
    
    /**
     * Konstruktor
     * parametr: komparator okrelajcy uporzdkowanie elementw
     */

    public SelectionSortListSorter(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";
        _comparator = comparator;
    }


    public List sort(List list) {
        assert list != null : "nie okrelono listy";

        int size = list.size();

        for (int slot = 0; slot < size - 1; ++slot) {
            int smallest = slot;
            for (int check = slot + 1; check < size; ++check) {
                if (_comparator.compare(list.get(check), list.get(smallest)) < 0) {
                    smallest = check;
                }
            }
            swap(list, smallest, slot);
        }

        return list;
    }

    private void swap(List list, int left, int right) {
        if (left == right) {     // czy istotnie chodzi o rne elementy?
            return;              // nie, nic nie rb.
        }
        Object temp = list.get(left);
        list.set(left, list.get(right));
        list.set(right, temp);
    }




}
