package com.wrox.algorithms.sorting;

import com.wrox.algorithms.iteration.Iterator;
import com.wrox.algorithms.lists.ArrayList;
import com.wrox.algorithms.lists.List;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;


public final class FileSortingHelper {

    private FileSortingHelper() {
    }


    public static void main(String[] args) throws IOException {
        sort(loadWords());

        System.err.println("Zakoczono...nacinij CTRL+C");

        try {
            Thread.sleep(0);
        } catch (InterruptedException e) {
            // ignoruj
        }
    }

    private static void sort(List wordList) {
        assert wordList != null : "nie okrelono listy sw";

        System.out.println("Rozpoczynam sortowanie...");

        Comparator comparator = ReverseStringComparator.INSTANCE;
        ListSorter sorter = new ShellsortListSorter(comparator);

        List sorted = sorter.sort(wordList);

        Iterator i = sorted.iterator();
        i.first();
        while (!i.isDone()) {
            System.out.println(i.current());
            i.next();
        }
    }

    private static List loadWords() throws IOException {
        List result = new ArrayList();

        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

        try {
            String word;

            while ((word = reader.readLine()) != null) {
                result.add(word);
            }
        } finally {
            reader.close();
        }

        return result;
    }
}
