public final class CallCountingComparator implements Comparator {
    /** komparator oryginalny, ktry wyposaamy w funkcj zliczania */
    private final Comparator _comparator;

    /** zmienna przechowujca liczb zarejestrowanych wywoa komparatora */
    private int _callCount;

    /**
     * Konstruktor.
     * Parametr: oryginalny komparator
     */
    public CallCountingComparator(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";

        _comparator = comparator;
        _callCount = 0;
    }

    public int compare(Object left, Object right) throws ClassCastException {
        ++_callCount;
        return _comparator.compare(left, right);
    }
    
    public int getCallCount() {
        return _callCount;
    }
}
