package com.wrox.algorithms.queues;

import com.wrox.algorithms.lists.LinkedList;
import com.wrox.algorithms.lists.List;

public class ListFifoQueue implements Queue {
    /** lista, na bazie ktrej implementowana jest kolejka */
    private final List _list;

    /**
     * Konstruktor tworzcy kolejk na bazie wskazanej listy
     *
     */

    public ListFifoQueue(List list) {
        assert list != null: "nie okrelono listy"
        _list = list;
    }

    /**
     * Domylny konstruktor tworzcy kolejk na bazie na bazie 
     * utworzonej ad hoc listy wizanej
     */
    public ListFifoQueue() {
        this(new LinkedList());
    }


    public void enqueue(Object value) {
        _list.add(value);
    }


    public Object dequeue() throws EmptyQueueException {
        if (isEmpty()) {
            throw new EmptyQueueException();
        }
        return _list.delete(0);
    }


    public void clear() {
        _list.clear();
    }

    public int size() {
        return _list.size();
    }

    public boolean isEmpty() {
        return _list.isEmpty();
    }


}
