public class CallGenerator {
    /** macierzyste centrum obsugi */
    private final CallCenter _callCenter;

    /** oglna liczba zgosze do wygenerowania */
    private final int _numberOfCalls;

    /** maksymalny czas obsugi zgoszenia */
    private final int _maxCallDuration;

    /** maksymalny odstp czasowy midzy kolejnymi zgoszeniami */
    private final int _maxCallInterval;

    /**
     * Konstruktor.
     * parametry: 
     *     macierzyste centrum obsugi 
     *     liczba zgosze do wygenerowania
     *     maksymalny czas obsugi zgoszenia
     *     maksymalny odstp czasowy midzy kolejnymi zgoszeniami
     */
    public CallGenerator(CallCenter callCenter, 
                         int numberOfCalls, 
                         int maxCallDuration, 
                         int maxCallInterval) {
        assert callCenter != null : "nie okrelono macierzystego centrum obsugi";
        assert numberOfCalls > 0 :  "liczba zgosze musi by dodatnia";
        assert maxCallDuration > 0 : "czas obsugi zgoszenia musi by dodatni";
        assert maxCallInterval > 0 : "czas midzy zgoszeniami musi by dodatni";

        _callCenter = callCenter;
        _numberOfCalls = numberOfCalls;
        _maxCallDuration = maxCallDuration;
        _maxCallInterval = maxCallInterval;
    }



    public void generateCalls() {
        for (int i = 0; i < _numberOfCalls; ++i) {
            sleep();
            _callCenter.accept(new Call(i, (int) (Math.random() * _maxCallDuration)));
        }
    }
    private void sleep() {
        try {
            Thread.sleep((int) (Math.random() * _maxCallInterval));
        } catch (InterruptedException e) {
            // Ignoruj
        }
    }







}
