package com.wrox.algorithms.iteration;

public class SingletonIterator implements Iterator {
    /** pojedyncza warto */
    private final Object _value;

    /** wskanik zakoczenia iteracji */
    private boolean _done;

    public SingletonIterator(Object value) {
        assert value != null : "nie okrelono wartoci";
        _value = value;
    }

    public void first() {
        _done = false;
    }

    public void last() {
        _done = false;
    }

    public boolean isDone() {
        return _done;
    }

    public void next() {
        _done = true;
    }

    public void previous() {
        _done = true;
    }

    public Object current() throws IteratorOutOfBoundsException {
        if (isDone()) {
            throw new IteratorOutOfBoundsException();
        }
        return _value;
    }
}
