package com.wrox.algorithms.iteration;

public class ReverseIterator implements Iterator {
    /** Iterator oryginalny */
    private final Iterator _iterator;

    /**
     * Konstruktor.
     * parametry wywoania: iterator oryginalny.
     */
    public ReverseIterator(Iterator iterator) {
        assert iterator != null : "nie okrelono iteratora";
        _iterator = iterator;
    }

    public boolean isDone() {
        return _iterator.isDone();
    }

    public Object current() throws IteratorOutOfBoundsException {
        return _iterator.current();
    }

    public void first() {
        _iterator.last();
    }

    public void last() {
        _iterator.first();
    }

    public void next() {
        _iterator.previous();
    }

    public void previous() {
        _iterator.next();
    }
    
}
