package com.wrox.algorithms.iteration;

public final class PowerCalculator {
    /** Pojedyncza, publicznie dostpna instancja kalkulatora */
    public static final PowerCalculator INSTANCE = new PowerCalculator();

    /** Prywatny konstruktor uniemoliwia samodzielne tworzenie instancji */
    private PowerCalculator() {
    }

    public int calculate(int base, int exponent) {
        assert exponent >= 0 : "Wykadnik nie moe by ujemny";

        int result = 1;

        for (int i = 0; i < exponent; ++i) {
            result *= base;
        }

        return result;
    }
}
