package com.wrox.algorithms.iteration;

public final class AndPredicate implements Predicate {
    /** lewy argument */
    private final Predicate _left;

    /** prawy argument */
    private final Predicate _right;

    public AndPredicate(Predicate left, Predicate right) {
        assert left != null : "nie okrelono lewego argumentu";
        assert right != null : "nie okrelono prawego argumentu";

        _left = left;
        _right = right;
    }

    public boolean evaluate(Object object) {
        return _left.evaluate(object) && _right.evaluate(object);
    }
}
