package com.wrox.algorithms.hashing;

public class LinearProbingHashtable implements Hashtable {
    /** Magazyn wartoci */
    private Object[] _values;

    /**
     * Konstruktor
     * Parametr: pocztkowy rozmiar tablicy
     */
    public LinearProbingHashtable(int initialCapacity) {
        assert initialCapacity > 0 : "rozmiar pocztkowy musi by dodatni";
        _values = new Object[initialCapacity];
    }

    public void add(Object value) {
        ensureCapacityForOneMore();

        int index = indexFor(value);

        if (_values[index] == null) {
            _values[index] = value;
        }
    }

    public boolean contains(Object value) {
        return indexOf(value) != -1;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < _values.length; ++i)  {
            if (_values[i] != null) {
                ++size;
            }
        }
        return size;
    }
        


    /**
     * Wylicza indeks dla podanej wartoci
     *
     * Parametr: warto do zapamitania
     * Wynik: indeks pozycji dla wartoci
     */
    private int indexFor(Object value) {
        int start = startingIndexFor(value);

        int index = indexFor(value, start, _values.length);
        if (index == -1) {
            index = indexFor(value, 0, start);
            assert index == -1 : "tablica cakowicie zapeniona";
        }

        return index;
    }

    /**
     * Wylicza indeks dla podanej wartoci
     *
     * Parametry: 
     *   - warto do zapamitania
     *   - pocztkowy indeks poszukiwania
     *   - kocowy indeks poszukiwania  
     * Wynik: indeks pozycji dla wartoci
     */

    private int indexFor(Object value, int start, int end) {
        assert value != null : "podano pust warto";

        for (int i = start; i < end; ++i) {
            if (_values[i] == null || value.equals(_values[i])) {
                return i;
            }
        }

        return -1;
    }

    /**
     * Wylicza indeks dla istniejcej wartoci
     *
     * Parametr: poszukiwana warto
     * Wynik: indeks szukanej wartoci lub -1, gdy nieznaleziona
     */
    private int indexOf(Object value) {
        int start = startingIndexFor(value);

        int index = indexOf(value, start, _values.length);
        if (index == -1) {
            index = indexOf(value, 0, start);
        }
        return index;
    }

    /**
     * Wylicza indeks dla szukanej wartoci
     *
     * Parametry: 
     *   - warto do zapamitania
     *   - pocztkowy indeks poszukiwania
     *   - kocowy indeks poszukiwania  
     * Wynik: indeks pozycji dla wartoci lub -1, gdy nieznaleziona
     */


    private int indexOf(Object value, int start, int end) {
        assert value != null : "podano pust warto";

        for (int i = start; i < end; ++i) {
            if (value.equals(_values[i])) {
                return i;
            }
        }

        return -1;
    }

    /**
     * Wylicza naturalny indeks dla podanej wartoci, bazujc na jej skrcie haszowym
     *
     * Parametr: warto, dla ktrej wyliczany jest indeks
     * Wynik: indeks dla wartoci
     */
    private int startingIndexFor(Object value) {
        assert value != null : "podano pust warto";
        return Math.abs(value.hashCode() % _values.length);
    }

    /**
     * Zapewnienie miejsca w tablicy na co najmniej jeszcze jedn warto
     */
    private void ensureCapacityForOneMore() {
        if (size() == _values.length) {
            resize();
        }
    }

    /**
     * reorganizacja tablicy
     */
    private void resize() {
        LinearProbingHashtable copy = new LinearProbingHashtable(_values.length * 2);

        for (int i = 0; i < _values.length; ++i) {
            if (_values[i] != null) {
                copy.add(_values[i]);
            }
        }

        _values = copy._values;
    }
}
