package com.wrox.algorithms.geometry;

import com.wrox.algorithms.sorting.Comparator;

public final class XYPointComparator implements Comparator {
    /** Pojedyncza instancja klasy komparatora (singleton) */
    public static final XYPointComparator INSTANCE = new XYPointComparator();

    private XYPointComparator() {
    }



    public int compare(Object left, Object right) throws ClassCastException {
        return compare((Point) left, (Point) right);
    }



    public int compare(Point p, Point q) throws ClassCastException {
        assert p != null : "nie okrelono pierwszego punktu";
        assert q != null : " nie okrelono drugiego punktu";

        int result = new Double(p.getX()).compareTo(new Double(q.getX()));
        if (result != 0) {
            return result;
        }
        return new Double(p.getY()).compareTo(new Double(q.getY()));
    }



}
