package com.wrox.algorithms.bsearch;

import com.wrox.algorithms.lists.List;

public class ListInserter {
    /** pomocnicza wyszukiwarka elementw */
    private final ListSearcher _searcher;

    /**
     * Konstruktor.
     * Parametr: instancja pomocniczej wyszukiwarki elementw
     */
    public ListInserter(ListSearcher searcher) {
        assert searcher != null : "nie okrelono wyszukiwarki";
        _searcher = searcher;
    }

    /**
     * Wstawienie wartoci do listy z zachowaniem jej posortowania     *
     * Parametry:
     *   - lista, do ktrej wstawiane s elementy
     *   - wstawiana warto
     * Zwracany wynik: pozycja, na ktr element zosta wstawiony
     */
    public int insert(List list, Object value) {
        assert list != null : "nie okrelono listy";

        int index = _searcher.search(list, value);

        if (index < 0) {
            index = -(index + 1);
        }

        list.insert(index, value);

        return index;
    }
}
