package com.wrox.algorithms.ssearch;

public class StringMatch {
    /** poszukiwany wzorzec */
    private final CharSequence _pattern;

    /** tekst, w ktrym prowadzone jest wyszukiwanie */
    private final CharSequence _text;

    /** pozycja (0, 1, 2...) pierwszego wystpienia wzorca w poszukiwanym tekcie */
    private final int _index;

    public StringMatch(CharSequence pattern, CharSequence text, int index) {
        assert text != null : "nie okrelono tekstu";
        assert pattern != null : "nie okrelono wzorca";
        assert index >= 0 : "pozycja startowa nie moe by ujemna";

        _text = text;
        _pattern = pattern;
        _index = index;
    }

    public CharSequence getPattern() {
        return _pattern;
    }

    public CharSequence getText() {
        return _text;
    }

    public int getIndex() {
        return _index;
    }
}
