package com.wrox.algorithms.ssearch;

public class BruteForceStringSearcher implements StringSearcher {

    /** poszukiwany wzorzec */
    private final CharSequence _pattern;

    public BruteForceStringSearcher(CharSequence pattern) {
        assert pattern != null : "nie okrelono wzorca";
        assert pattern.length() > 0 : "wzorzec nie moe by pusty";

        _pattern = pattern;
    }

    public StringMatch search(CharSequence text, int from) {
        assert text != null : "nie okrelono przeszukiwanego acucha";
        assert from >= 0 : "pozycja startowa nie moe by ujemna";

        int s = from;

        while (s <= text.length() - _pattern.length()) {
            int i = 0;

            while (i < _pattern.length() && _pattern.charAt(i) == text.charAt(s + i)) {
                ++i;
            }

            if (i == _pattern.length()) {
                return new StringMatch(_pattern, text, s);
            }

            ++s;
        }

        return null;
    }
}
