package com.wrox.algorithms.sorting;

import com.wrox.algorithms.lists.List;

public class BubblesortListSorter implements ListSorter {
    private final Comparator _comparator;

    /**
     * Konstruktor
     * parametr: komparator okrelajcy uporzdkowanie elementw
     */

    public BubblesortListSorter(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";
        _comparator = comparator;
    }



    public List sort(List list) {
        assert list != null : "nie okrelono listy wejciowej";

        int size = list.size();

        for (int pass = 1; pass < size; ++pass) {                // ptla zewntrzna
            for (int left = 0; left < (size - pass); ++left) {   // ptla wewntrzna
                int right = left + 1;
                if (_comparator.compare(list.get(left), list.get(right)) > 0) {
                    swap(list, left, right);
                }
            }
        }

        return list;
    }


    private void swap(List list, int left, int right) {
        Object temp = list.get(left);
        list.set(left, list.get(right));
        list.set(right, temp);
    }





}
