package com.wrox.algorithms.queues;

public final class CallCenterSimulator {
    /** liczba spodziewanych parametrw wywoania */
    private static final int NUMBER_OF_ARGS = 4;

    /** indeks parametru oznaczajcego liczb konsultantw */
    private static final int NUMBER_OF_AGENTS_ARG = 0;

    /** indeks parametru oznaczajcego liczb generowanych zgosze */
    private static final int NUMBER_OF_CALLS_ARG = 1;

    /** indeks parametru oznaczajcego maksymalny czas obsugi zgoszenia */
    private static final int MAX_CALL_DURATION_ARG = 2;

    /** indeks parametru oznaczajcego maksymalny odstp czasowy 
     * midzy kolejnymi zgoszeniami 
     */
    private static final int MAX_CALL_INTERVAL_ARG = 3;

    /**
     * Konstruktor prywatny, uniemoliwia samodzielne tworzenie instancji
     */
    private CallCenterSimulator() {
    }

public static void main(String[] args) {
        assert args != null : "nie podano parametrw";

        if (args.length != NUMBER_OF_ARGS) {
            System.out.println(
              "Wywoanie: CallGenerator <konsultanci><zgoszenia>"
                               + "<czas obsugi> <odstp czasowy>");
            System.exit(-1);
        }

        CallCenter callCenter = 
            new CallCenter(Integer.parseInt(args[NUMBER_OF_AGENTS_ARG]));

        CallGenerator callGenerator = 
           new CallGenerator(callCenter, 
                                 Integer.parseInt(args[NUMBER_OF_CALLS_ARG]),
                                 Integer.parseInt(args[MAX_CALL_DURATION_ARG]),
                                 Integer.parseInt(args[MAX_CALL_INTERVAL_ARG]));

        callCenter.open();
        try {
            callGenerator.generateCalls();
        } finally {
            callCenter.close();
        }
    }
}
