package com.wrox.algorithms.geometry;

public class Point {
    private final double _x;
    private final double _y;

    public Point(double x, double y) {
        _x = x;
        _y = y;
    }


    public double getX() {
        return _x;
    }

    public double getY() {
        return _y;
    }


    public double distance(Point other) {
        assert other != null : "nie okrelono punktu docelowego";

        double wzniesienie = getY() - other.getY();
        double przesuniecie = getX() - other.getX();

        return Math.sqrt(wzniesienie * wzniesienie + przesuniecie * przesuniecie);
    }


    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null || obj.getClass() != getClass()) {
            return false;
        }

        Point other = (Point) obj;

        return getX() == other.getX() && getY() == other.getY();
    }


    public int hashCode() {
        return (int) (_x * _y);
    }



}
