/*****************************************************************************
*                                                                            *
*  ------------------------------- ctsort.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "sort.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- ctsort --------------------------------  *
*                                                                            *
*****************************************************************************/

int ctsort(int *data, int size, int k) {

int                *counts,
                   *temp;

int                i,
                   j;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na liczniki.                                             *
*                                                                            *
*****************************************************************************/

if ((counts = (int *)malloc(k * sizeof(int))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na posortowane elementy.                                 *
*                                                                            *
*****************************************************************************/

if ((temp = (int *)malloc(size * sizeof(int))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja licznikw.                                                  *
*                                                                            *
*****************************************************************************/

for (i = 0; i < k; i++)
   counts[i] = 0;

/*****************************************************************************
*                                                                            *
*  Zliczanie wystpie poszczeglnych elementw.                             *
*                                                                            *
*****************************************************************************/

for (j = 0; j < size; j++)
   counts[data[j]] = counts[data[j]] + 1;

/*****************************************************************************
*                                                                            *
*  Korekta poszczeglnych licznikw, aby zawieray liczb poprzedzajcych    *
*  je elementw.                                                             *
*                                                                            *
*****************************************************************************/

for (i = 1; i < k; i++)
   counts[i] = counts[i] + counts[i - 1];

/*****************************************************************************
*                                                                            *
*  Uycie counts do pooenia poszczeglnych elementw w odpowiednie miejsca.*
*                                                                            *
*****************************************************************************/

for (j = size - 1; j >= 0; j--) {

   temp[counts[data[j]] - 1] = data[j];
   counts[data[j]] = counts[data[j]] - 1;

}

/*****************************************************************************
*                                                                            *
*  Przygotowanie posortowanych danych do zwrcenia.                          *
*                                                                            *
*****************************************************************************/

memcpy(data, temp, size * sizeof(int));

/*****************************************************************************
*                                                                            *
*  Zwolnienie pamici uytej do sortowania.                                  *
*                                                                            *
*****************************************************************************/

free(counts);
free(temp);

return 0;

}
