/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja uycia sterty (rozdzia 10.)                             *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "heap.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_heap ------------------------------  *
*                                                                            *
*****************************************************************************/

static void print_heap(Heap *heap) {

int                i;

/*****************************************************************************
*                                                                            *
*  Pokazanie sterty poziomami.                                               *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar sterty to %d\n", heap_size(heap));

for (i = 0; i < heap_size(heap); i++)
   fprintf(stdout, "Node=%03d\n", *(int *)heap->tree[i]);

return;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ compare_int -----------------------------  *
*                                                                            *
*****************************************************************************/

static int compare_int(const void *int1, const void *int2) {

/*****************************************************************************
*                                                                            *
*  Porwnanie dwch liczb cakowitych.                                       *
*                                                                            *
*****************************************************************************/

if (*(const int *)int1 > *(const int *)int2)
   return 1;
else if (*(const int *)int1 < *(const int *)int2)
   return -1;
else
   return 0;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

Heap               heap;

void               *data;

int                intval[30],
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja sterty.                                                     *
*                                                                            *
*****************************************************************************/

heap_init(&heap, compare_int, NULL);

/*****************************************************************************
*                                                                            *
*  Operacje na stercie.                                                      *
*                                                                            *
*****************************************************************************/

i = 0;

intval[i] = 5;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 10;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 20;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 1;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 25;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 22;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

intval[i] = 9;
fprintf(stdout, "Wstawianie %03d\n", intval[i]);
if (heap_insert(&heap, &intval[i]) != 0)
   return 1;
print_heap(&heap);
i++;

while (heap_size(&heap) > 0) {

   if (heap_extract(&heap, (void **)&data) != 0)
      return 1;
   fprintf(stdout, "Pobieranie %03d\n", *(int *)data);
   print_heap(&heap);

}

/*****************************************************************************
*                                                                            *
*  Usunicie sterty.                                                         *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie sterty\n");
heap_destroy(&heap);

return 0;

}
