/*************************************************************************
 *  Kompilacja:  javac TopM.java
 *  Wykonanie:    java TopM M < input.txt
 *  Zalenoci: MinPQ.java
 *  Plik z danymi:   http://algs4.cs.princeton.edu/24pq/tinyBatch.txt
 * 
 *  Na podstawie liczby cakowitej M z wiersza polece i strumienia wejciowego, w ktrym
 *  kady wiersz obejmuje acuch znakw i warto typu long, niniejszy klient klasy MinPQ
 *  wywietla M wierszy z najwikszymi liczbami.
 * 
 *  % java TopM 5 < tinyBatch.txt 
 *  Thompson    2/27/2000  4747.08
 *  vonNeumann  2/12/1994  4732.35
 *  vonNeumann  1/11/1999  4409.74
 *  Hoare       8/18/1992  4381.21
 *  vonNeumann  3/26/2002  4121.85
 *
 *************************************************************************/

public class TopM {   

    // Wywietla M pierwszych wierszy ze strumienia wejciowego. 
    public static void main(String[] args) {
        int M = Integer.parseInt(args[0]); 
        MinPQ<Transaction> pq = new MinPQ<Transaction>(M+1); 

        while (StdIn.hasNextLine()) {
            // Tworzy element na podstawie nastpnego wiersza i umieszcza go w kolejce priorytetowej. 
            String line = StdIn.readLine();
            Transaction transaction = new Transaction(line);
            pq.insert(transaction); 

            // Usuwanie minimum, jeli w kolejce priorytetowej znajduje si M+1 elementw
            if (pq.size() > M) 
                pq.delMin();
        }   // M pierwszych elementw znajduje si w kolejce priorytetowej

        // Wywietlanie elementw z kolejki priorytetowej w odwrotnej kolejnoci
        Stack<Transaction> stack = new Stack<Transaction>();
        for (Transaction transaction : pq)
            stack.push(transaction);
        for (Transaction transaction : stack)
            StdOut.println(transaction);
    } 
} 

