/*************************************************************************
 *  Kopilacja:  javac Edge.java
 *  Wykonanie:    java Edge
 *
 *  Typ danych dla niezmiennych krawdzi waonych.
 *
 *************************************************************************/

/**
 *  Klasa <tt>Edge</tt> reprezetuje krawd waon nieskierowanego grafu.
 *  <p>
 *  Dodatkow dokumentacj mona znale w <a href="/algs4/43mst">podrozdziale 4.3</a> ksiki
 *  <i>Algorytmy, wydanie czwarte</i> Roberta Sedgewicka i Kevina Wayne'a.
 */
public class Edge implements Comparable<Edge> { 

    private final int v;
    private final int w;
    private final double weight;

   /**
     * Tworzenie krawdzi o danej wadze midzy v a w.
     */
    public Edge(int v, int w, double weight) {
        this.v = v;
        this.w = w;
        this.weight = weight;
    }

   /**
     * Zwracanie wagi krawdzi.
     */
    public double weight() {
        return weight;
    }

   /**
     * Zwracanie jednego z punktw kocowych krawdzi.
     */
    public int either() {
        return v;
    }

   /**
     * Zwracanie punktu kocowego krawdzi innego ni podany wierzchoek
     * (chyba e krawd tworzy ptl zwrotn).
     */
    public int other(int vertex) {
        if      (vertex == v) return w;
        else if (vertex == w) return v;
        else throw new RuntimeException("Niedozwolony punkt koncowy");
    }

   /**
     * Porwnywanie krawdzi na podstawie wag.
     */
    public int compareTo(Edge that) {
        if      (this.weight() < that.weight()) return -1;
        else if (this.weight() > that.weight()) return +1;
        else                                    return  0;
    }

   /**
     * Zwracanie acucha znakw reprezentujcego krawd.
     */
    public String toString() {
        return String.format("%d-%d %.2f", v, w, weight);
    }


   /**
     * Klient testowy.
     */
    public static void main(String[] args) {
        Edge e = new Edge(12, 23, 3.14);
        StdOut.println(e);
    }
}
