/*************************************************************************
 *  Kompilacja:  javac BlackFilter.java
 *  Wykonanie:    java BlackFilter blacklist.txt < input.txt
 *  Zalenoci: SET In.java StdIn.java
 *
 *  Wczytuje czarn list sw z pliku. Nastpnie wczytuje list sw
 *  ze standardowego wejcia i wywietla wszystkie sowa, ktre nie
 *  wystpuj w pierwszym pliku.
 * 
 *  % more list.txt 
 *  was it the of 
 * 
 *  % java BlackFilter list.txt < tinyTale.txt 
 *  best times worst times 
 *  age wisdom age foolishness 
 *  epoch belief epoch incredulity 
 *  season light season darkness 
 *  spring hope winter despair 
 *
 *************************************************************************/

public class BlackFilter {  
    public static void main(String[] args) {
        SET<String> set = new SET<String>();

        // Wczytuje acuchy znakw i dodaje je do zbioru.
        In in = new In(args[0]);
        while (!in.isEmpty()) {
            String word = in.readString();
            set.add(word);
        }

        // Wczytuje acuch znakw ze standardowego wejcia i wywietla wszystkie wyjtki.
        while (!StdIn.isEmpty()) {
            String word = StdIn.readString();
            if (!set.contains(word))
                StdOut.println(word);
        }
    }
}
