unit MvcMdiF;
//*******************************************************
// MDI form for example program demonstrating the
// Model/View/Controller (MVC) paradigm.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  Menus,
  MvcModel, MvcPieV, MvcTabV, MvcTabF, MvcGraV, MvcGraF;

type
  TMvcMdiForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Window1: TMenuItem;
    mnuTile: TMenuItem;
    mnuCascade: TMenuItem;
    mnuArrange: TMenuItem;
    mnuNewTable: TMenuItem;
    mnuNewGraph: TMenuItem;
    mnuNewPie: TMenuItem;
    N1: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuTileClick(Sender: TObject);
    procedure mnuCascadeClick(Sender: TObject);
    procedure mnuArrangeClick(Sender: TObject);
    procedure mnuNewTableClick(Sender: TObject);
    procedure mnuNewGraphClick(Sender: TObject);
    procedure mnuNewPieClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    TheModel : TMvcModel;

  public
    { Public declarations }
  end;

var
  MvcMdiForm: TMvcMdiForm;

implementation

uses MvcPieF;

{$R *.DFM}

procedure TMvcMdiForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TMvcMdiForm.mnuTileClick(Sender: TObject);
begin
    TileMode := tbVertical;
    Tile;
end;

procedure TMvcMdiForm.mnuCascadeClick(Sender: TObject);
begin
    Cascade;
end;

procedure TMvcMdiForm.mnuArrangeClick(Sender: TObject);
begin
    ArrangeIcons;
end;

// Create a new TTableForm and view.
procedure TMvcMdiForm.mnuNewTableClick(Sender: TObject);
var
    frm : TTableForm;
begin
    frm := TTableForm.Create(Self);
    TMvcTableView.Create(TheModel, frm);
end;

// Create a new TGraphForm and view.
procedure TMvcMdiForm.mnuNewGraphClick(Sender: TObject);
var
    frm : TGraphForm;
begin
    frm := TGraphForm.Create(Self);
    TMvcGraphView.Create(TheModel, frm);
end;

// Create a new TPieForm and view.
procedure TMvcMdiForm.mnuNewPieClick(Sender: TObject);
var
    frm : TPieForm;
begin
    frm := TPieForm.Create(Self);
    TMvcPieView.Create(TheModel, frm);
end;

procedure TMvcMdiForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin


    MessageDlg(
        'Niniejszy program demonstruje zastosowanie paradygmatu MVC (Model/Widok/Kontroler).' + CRCR +
        'Losowo wygenerowane dane finansowe mog by prezentowane w dowolnej liczbie wykresw o trzech nastpujcych postaciach:' + CRCR +
        '   - wykresu paskowego (widok/kontroler)' + CR +
        '   - wykresu koowego ("torcika" - widok)' + CR +
        '   - tabeli (widok/kontroler)' + CRCR +
        'Kadorazowa zmiana wartoci w ramach tabeli lub wykresu paskowego spowoduje automatyczne uaktualnienie pozostaych widokw.'
        , mtInformation, [mbOK], 0);



end;

// Create the model.
procedure TMvcMdiForm.FormCreate(Sender: TObject);
begin
    TheModel := TMvcModel.Create;
end;

end.
