unit MvcGraV;
//*******************************************************
// Bar graph view for example program demonstrating the
// Model/View/Controller (MVC) paradigm.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
    MvcModel, MvcGraF;
    
type
    TMvcGraphView = class(TMvcView)
        private
            TheGraphForm : TGraphForm;
        public
            constructor Create(model : TMvcModel; frm : TGraphForm);
            procedure DataModified; override;
    end;

implementation

// Save a reference to the form.
constructor TMvcGraphView.Create(model : TMvcModel; frm : TGraphForm);
begin
    // We save the form first because Create in the
    // TMvcView base class calls DataModified.
    TheGraphForm := frm;
    frm.TheModel := model;
    frm.TheView := Self;

    inherited Create(model);
end;

// Update the view display.
procedure TMvcGraphView.DataModified;
begin
    TheGraphForm.Refresh;
end;

end.
