unit PriorQF;
//*******************************************************
// Example program demonstrating linked list-based
// priority queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//
// Revised (C) 1999 Andrzej Grayski, HELION Publ.
//
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  PriorQC, Classes;

type
  TPriorQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    Label1: TLabel;
    CmdEnterQueue: TButton;
    CmdLeaveQueue: TButton;
    QueueLabel: TLabel;
    Label2: TLabel;
    PriorityText: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
    procedure CmdEnterQueueClick(Sender: TObject);
    procedure CmdLeaveQueueClick(Sender: TObject);
    procedure PriorityTextChange(Sender: TObject);
    procedure PriorityTextKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PriorQForm: TPriorQForm;

implementation

var
    the_queue : TPriorityQueue;

{$R *.DFM}

procedure TPriorQForm.FormCreate(Sender: TObject);
begin
    // Make the queue.
    the_queue := TPriorityQueue.Create;
end;

procedure TPriorQForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

procedure TPriorQForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin


    MessageDlg(
        'Niniejszy program prezentuje funkcjonowanie kolejki priorytetowej' + CR +
        'zrealizowanej jako jednokierunkowa lista czona z wartownikami.' + CR +
        'Elementy listy utrzymywane s w kolejnoci malejcych priorytetw.' + CRCR +
        'Wprowad nowy acuch i okrel jego priorytet, a nastpnie kliknij w przycisk' + CR +
        '"Wprowad do kolejki" - spowoduje to umieszczenie acucha na pozycji' + CR +
        'odpowiadajcej jego priorytetowi.' + CRCR +
        'Kliknicie w przycisk "Pobierz z kolejki" spowoduje pobranie elementu czoowego,' + CR +
        'gdy to wanie on posiada najwyszy priorytet.'
      , mtInformation, [mbOK], 0);


end;

procedure TPriorQForm.ItemTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
end;

procedure TPriorQForm.CmdEnterQueueClick(Sender: TObject);
begin
    the_queue.EnterQueue(ItemText.Text, StrToInt(PriorityText.Text));
    QueueLabel.Caption := the_queue.TextValue;
    ItemText.Text := '';
    PriorityText.Text := '';
    ItemText.SetFocus;
    CmdEnterQueue.Enabled := False;
    CmdLeaveQueue.Enabled := True;
end;

procedure TPriorQForm.CmdLeaveQueueClick(Sender: TObject);
begin
    ItemText.Text := the_queue.LeaveQueue;
    PriorityText.Text := '';
    ItemText.SetFocus;
    QueueLabel.Caption := the_queue.TextValue;
    CmdEnterQueue.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
    CmdLeaveQueue.Enabled := (not the_queue.QueueEmpty);
end;

procedure TPriorQForm.PriorityTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
end;

procedure TPriorQForm.PriorityTextKeyPress(Sender: TObject;
  var Key: Char);
begin
    if (Key = #8) then exit; // Backspace.
    if ((Key >= '0') and (Key <= '9')) then exit;
    Key := #0;
end;

end.
