unit LStackC;
//*******************************************************
// Linked list-based stack class.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
    Dialogs, SysUtils, Classes;

type
    // Komrki listy
    String10 = String[10];
    PStackCell = ^TStackCell;
    TStackCell = record
        Value    : String10;   // The data.
        NextCell : PStackCell; // The next cell.
    end;

    // Klasa reprezentujca list czon
    TStack = class(TObject)
        private
            Top : PStackCell; // Wskanik na pierwszy element

        public
            destructor Destroy; override;
            procedure Push(new_value : String10);
            function Pop : String10;
            function StackEmpty : Boolean;
            function TextValue : String;
            procedure EmptyStack;
    end;

implementation

// Zwolnij obiekt
destructor TStack.Destroy;
begin
    EmptyStack;
    inherited Destroy;
end;

// Umie element na stosie
procedure TStack.Push(new_value : String10);
var
    new_cell : PStackCell;
begin
    // Twrz now komrk
    New(new_cell);
    new_cell^.Value := new_value;

    // Wstaw komrk reprezentujc element na pierwsz pozycj
    new_cell^.NextCell := Top;
    Top := new_cell;
end;

// Usu pierwsz komrk z listy
function TStack.Pop : String10;
var
    target : PStackCell;
begin
    if (Top = nil) then
        raise EInvalidOperation.Create(
            'Cannot pop items from an empty stack.');

    // Zachowaj wskanik do usuwanej komrki
    target := Top;
    Pop := target^.Value;

    // Usu komrk
    Top := target^.NextCell;

    // Zwolnij usunit komrk
    Dispose(target);
end;

// Sprawd, czy stos jest pusty
function TStack.StackEmpty : Boolean;
begin
    StackEmpty := (Top = nil);
end;

// Utwrz acuch reprezentujcy zawarto stosu jako caoci
function TStack.TextValue : String;
const
    CR = #13#10;
var
    cell_ptr : PStackCell;
begin
    Result := '';
    cell_ptr := Top;
    while (cell_ptr <> nil) do
    begin
        Result := Result + cell_ptr^.Value + CR;
        cell_ptr := cell_ptr^.NextCell;
    end;
end;

// Usu wszystkie elementy ze stosu
procedure TStack.EmptyStack;
var
    target : PStackCell;
begin
    while (Top <> nil) do
    begin
        target := Top;
        Top := Top^.NextCell;
        Dispose(target);
    end;
end;

end.
