unit ThreadsF;
//*******************************************************
// Example program demonstrating threaded linked lists.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  ThreadsC, Classes, ExtCtrls;

type
  TThreadsForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    GroupBox1: TGroupBox;
    CmdAdd: TButton;
    CmdClear: TButton;
    Label1: TLabel;
    LastNameEdit: TEdit;
    FirstNameEdit: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SSNEdit: TEdit;
    GenderEdit: TEdit;
    JobClassEdit: TEdit;
    OrderGroup: TRadioGroup;
    ListLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure CmdClearClick(Sender: TObject);
    procedure TextChange(Sender: TObject);
    procedure ShowList(move_type : TMoveType);
    procedure CmdAddClick(Sender: TObject);
    procedure OrderGroupClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ThreadsForm: TThreadsForm;

implementation

var
    the_list    : TThreadedList;

{$R *.DFM}

procedure TThreadsForm.FormCreate(Sender: TObject);
begin
    // Make the list.
    the_list := TThreadedList.Create;
end;

procedure TThreadsForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

procedure TThreadsForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin


    MessageDlg(
        'Program ilustruje funkcjonowanie listy wielowtkowej.' + CRCR +
        'Wprowad now warto i kliknij przycisk Dodaj.' + CRCR +
        'Uporzdkuj elementy zgodnie ze swymi potrzebami.' + CRCR +
        'Przycisk Czy usuwa wszystkie elementy z listy.'
        , mtInformation, [mbOK], 0);


end;

procedure TThreadsForm.CmdClearClick(Sender: TObject);
begin
    the_list.ClearList;
    ShowList(TMoveType(OrderGroup.ItemIndex));
    LastNameEdit.SetFocus;
end;

procedure TThreadsForm.TextChange(Sender: TObject);
begin
    CmdAdd.Enabled :=
        ((LastNameEdit.Text <> '') and
         (FirstNameEdit.Text <> '') and
         (SSNEdit.Text <> '') and
         (GenderEdit.Text <> '') and
         (JobClassEdit.Text <> ''));
end;

procedure TThreadsForm.ShowList(move_type : TMoveType);
var
    txt : String;
begin
    the_list.MoveFirst(move_type);
    while (not the_list.EndOfList) do
    begin
        txt := txt + the_list.CurrentItem;
        the_list.MoveNext(move_type);
    end;

    ListLabel.Caption := txt;
end;

procedure TThreadsForm.CmdAddClick(Sender: TObject);
begin
    the_list.Add(LastNameEdit.Text, FirstNameEdit.Text,
        SSNEdit.Text, GenderEdit.Text,
        StrToInt(JobClassEdit.Text));
    ShowList(TMoveType(OrderGroup.ItemIndex));
    LastNameEdit.Text := '';
    FirstNameEdit.Text := '';
    SSNEdit.Text := '';
    GenderEdit.Text := '';
    JobClassEdit.Text := '';
    LastNameEdit.SetFocus;
end;

procedure TThreadsForm.OrderGroupClick(Sender: TObject);
begin
    ShowList(TMoveType(OrderGroup.ItemIndex));
end;

end.
