unit SizeArrF;
//*******************************************************
// Example program demonstrating array resizing.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
    // Define array type.
    TIntArray = array [1..1000000] of Integer;

    // Define pointer to array type.
    PIntArray = ^TIntArray;

  TSizeArrForm = class(TForm)
    Label1: TLabel;
    NumItemsText: TEdit;
    CmdResize: TButton;
    ItemsLabel: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure CmdResizeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SizeArrForm: TSizeArrForm;

implementation

{$R *.DFM}

procedure TSizeArrForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TSizeArrForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin
    MessageDlg(
        'This program demonstrates array resizing.' + CRCR +
        'When you enter a number and click the Resize button, the program resizes its array. ' +
        'It then fills the array with sequential numbers and displays them'
        , mtInformation, [mbOK], 0);
end;

// Resize the array.
procedure TSizeArrForm.CmdResizeClick(Sender: TObject);
var
    NumItems : Integer;    // Array item count.
    Items    : PIntArray;  // Array of items.
    i        : Integer;
    txt      : String;
begin
    // Allocate space for the array.
    NumItems := StrToInt(NumItemsText.Text);
    GetMem(Items, NumItems * SizeOf(Integer));

    // Fill the array with values.
    for i := 1 to NumItems do
    begin
        Items^[i] := i;
        txt := txt + IntToStr(Items^[i]) + ' ';
    end;
    ItemsLabel.Caption := txt;

    // Free the array.
    FreeMem(Items);
end;

end.
