unit SimListF;
//*******************************************************
// Example program demonstrating a simple resizable
// array-based list.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SimListC, Menus, StdCtrls;

type
  TSimListForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    CmdAdd10: TButton;
    CmdRemove10: TButton;
    ItemText: TEdit;
    CmdAdd: TButton;
    CmdRemove: TButton;
    ListScrollBox: TScrollBox;
    ListLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure SetButtonEditability;
    procedure CmdAdd10Click(Sender: TObject);
    procedure CmdRemove10Click(Sender: TObject);
    procedure CmdAddClick(Sender: TObject);
    procedure CmdRemoveClick(Sender: TObject);
    procedure ShowList;
    procedure FormResize(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SimListForm: TSimListForm;

implementation

var
    the_list : TSimpleList;

{$R *.DFM}

procedure TSimListForm.FormCreate(Sender: TObject);
begin
    // Create the TSimpleList object.
    the_list := TSimpleList.Create;
end;

procedure TSimListForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin
    MessageDlg(
        'This program demonstrates a simple list class using resizable arrays.' + CRCR +
        'Enter a string and click the Add button to add an item to the end of the list.' + CRCR +
        'Click Remove to remove the last item from the list.' + CRCR +
        'Click Add 10 or Remove 10 to add or remove 10 items at once.'
        , mtInformation, [mbOK], 0);
end;

procedure TSimListForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TSimListForm.SetButtonEditability;
begin
    CmdAdd.Enabled := (ItemText.Text <> '');
    CmdRemove.Enabled := (the_list.Count > 0);
    CmdRemove10.Enabled := (the_list.Count > 0);
end;

procedure TSimListForm.CmdAdd10Click(Sender: TObject);
var
    i : Longint;
begin
    for i := 1 to 10 do
        the_list.Add(IntToStr(the_list.Count));
    SetButtonEditability;
    ShowList;
end;

procedure TSimListForm.CmdRemove10Click(Sender: TObject);
var
    i : Longint;
begin
    for i := 1 to 10 do
        if (the_list.Count > 0) then
            the_list.RemoveLast;
    SetButtonEditability;
    ShowList;
end;

procedure TSimListForm.CmdAddClick(Sender: TObject);
begin
    the_list.Add(ItemText.Text);
    SetButtonEditability;
    ShowList;
end;

procedure TSimListForm.CmdRemoveClick(Sender: TObject);
begin
    the_list.RemoveLast;
    SetButtonEditability;
    ShowList;
end;

procedure TSimListForm.ShowList;
const
    CR = #13#10;
var
    i   : Longint;
    txt : String;
begin
    for i := 1 to the_list.Count do
        txt := txt + the_list.Item(i) + CR;
    ListLabel.Caption := txt;
    ItemText.Text := '';
end;

// Make the TScrollBox as large as possible.
procedure TSimListForm.FormResize(Sender: TObject);
var
    wid, hgt : Integer;
begin
    wid := ClientWidth - 2 * CmdAdd.Left - CmdAdd.Width;
    if (wid < 20) then wid := 20;
    ListScrollBox.Width := wid;
    hgt := ClientHeight - CmdAdd.Left;
    if (hgt < 20) then hgt := 20;
    ListScrollBox.Height := hgt;
end;

procedure TSimListForm.ItemTextChange(Sender: TObject);
begin
    CmdAdd.Enabled := (ItemText.Text <> '');
end;

end.
