unit SerLine;
//*******************************************************
// Serializable command object that draws a line.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses SerDraw, Graphics;

type
    TLineCmd = class(TDrawingCommand)
        public
            procedure Draw(cvs : TCanvas; permanent : Boolean); override;
            function Serialization : String; override;
    end;

implementation

// Draw a line segment.
procedure TLineCmd.Draw(cvs : TCanvas; permanent : Boolean);
begin
    if (permanent) then cvs.Pen.Color := color;
    cvs.MoveTo(x1, y1);
    cvs.LineTo(x2, y2);
end;

// Return the object's serialization. TDrawingCommand does
// most of the work.
function TLineCmd.Serialization : String;
const
    CR = #13#10;
begin
    Result := 'TLineCmd(' + CR +
        inherited Serialization + ')';
end;

end.
