unit MvcPieV;
//*******************************************************
// Pie chart view class for example program demonstrating
// the Model/View/Controller (MVC) paradigm.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
    MvcModel, MvcPieF;
    
type
    TMvcPieView = class(TMvcView)
        private
            ThePieForm : TPieForm;
        public
            constructor Create(model : TMvcModel; frm : TPieForm);
            procedure DataModified; override;
    end;

implementation

// Save a reference to the form.
constructor TMvcPieView.Create(model : TMvcModel; frm : TPieForm);
begin
    // We save the form first because Create in the
    // TMvcView base class calls DataModified.
    ThePieForm := frm;
    frm.TheModel := model;
    frm.TheView := Self;

    inherited Create(model);
end;

// Update the view display.
procedure TMvcPieView.DataModified;
begin
    ThePieForm.Refresh;
end;

end.
