unit Cmd2Line;
//*******************************************************
// A command class that draws a line.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses Cmd2Draw, Graphics;

type
    TLineCmd = class(TDrawingCommand)
        public
            procedure Draw(cvs : TCanvas; permanent : Boolean); override;
    end;

implementation

// Draw a line segment.
procedure TLineCmd.Draw(cvs : TCanvas; permanent : Boolean);
begin
    if (permanent) then cvs.Pen.Color := color;
    cvs.MoveTo(x1, y1);
    cvs.LineTo(x2, y2);
end;

end.
