unit Cmd2Draw;
//*******************************************************
// The TDrawingCommand base class from which other
// command classes are derived.
//
// The class defines the abstract virtual Draw method
// implemented by derived drawing command classes.
//
// Deriving command classes from this class allows a
// program to treat the commands polymorphically as
// TDrawingCommand objects.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses Forms, Graphics, ExtCtrls;

type
    TDrawingCommand = class(TObject)
        protected
            x1, y1, x2, y2 : Integer;
            color          : TColor;
            style          : TBrushStyle;

        public
            procedure SetPosition(new_x1, new_y1, new_x2, new_y2 : Integer);
            procedure SetColorAndStyle(new_color : TColor; new_style : TBrushStyle);
            procedure Draw(cvs : TCanvas; permanent : Boolean); virtual; abstract;
    end;

implementation

procedure TDrawingCommand.SetPosition(new_x1, new_y1, new_x2, new_y2 : Integer);
begin
    x1 := new_x1;
    y1 := new_y1;
    x2 := new_x2;
    y2 := new_y2;
end;

procedure TDrawingCommand.SetColorAndStyle(new_color : TColor; new_style : TBrushStyle);
begin
    color := new_color;
    style := new_style;
end;

end.
