unit SingleF;
//*******************************************************
// Example program demonstrating singleton objects.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  SingleC;

type
  TSingleForm = class(TForm)
    ListMemo: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    List1: TMenuItem;
    Refresh1: TMenuItem;
    Help1: TMenuItem;
    AboutThisProgram1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Refresh1Click(Sender: TObject);
    procedure AboutThisProgram1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SingleForm: TSingleForm;

implementation

{$R *.DFM}

procedure TSingleForm.Exit1Click(Sender: TObject);
begin
    Close;
end;

procedure TSingleForm.FormResize(Sender: TObject);
begin
    ListMemo.Width := ClientWidth;
    ListMemo.Height := ClientHeight;
end;

// Display a list of the running main windows.
procedure TSingleForm.Refresh1Click(Sender: TObject);
begin
    ListMemo.Text := '';
    Screen.Cursor := crHourGlass;
    Refresh;
    ListMemo.Text := WindowLister.WindowList;
    Screen.Cursor := crDefault;
end;

procedure TSingleForm.AboutThisProgram1Click(Sender: TObject);
begin


    MessageDlg(
        'Niniejszy program wykorzystuje obiekt typu Singleton do wywietlania listy okien gwnych.'
        , mtInformation, [mbOK], 0);



end;

// Initially refresh the window list.
procedure TSingleForm.FormCreate(Sender: TObject);
begin
    Refresh1Click(Sender);
end;

end.
