unit SingleC;
//*******************************************************
// A TWindowLister class and its singleton object.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
    SysUtils, Windows;

type
    TWindowLister = class(TObject)
        public
            constructor Create; virtual; abstract;
            function WindowList : String; 
    end;

// Public function that returns the singleton.
function WindowLister : TWindowLister;

implementation

type
    // Subclass that can be instantiated.
    TAWindowLister = class(TWindowLister)
        public
            constructor Create; override;
    end;

// The single instance of TAWindowLister.
var
    TheWindowLister : TAWindowLister;

// ------------------------------------------------------
// A public function that instantiates and returns the
// singleton.
// ------------------------------------------------------
function WindowLister : TWindowLister;
begin
    if (TheWindowLister = nil) then
        TheWindowLister := TAWindowLister.Create;

    Result := TheWindowLister;
end;

// ------------------------------------------------------
// TWindowLister
// ------------------------------------------------------
// Return the window list.
function TWindowLister.WindowList : String;
const
    CR = #13#10;
    MAX_CHAR = 256;
var
    desktop_hWnd, next_hWnd, buflen : Longint;
    buf : array [0..MAX_CHAR] of Char;
begin
    Result := 'hWnd       Tytu' + CR + '---------- -----';

    // Get the desktop window handle.
    desktop_hWnd := GetDesktopWindow;

    // Get the first of the desktop's child windows.
    next_hWnd := GetWindow(desktop_hWnd, GW_CHILD);
    while (next_hWnd <> 0) do
    begin
        buflen := GetWindowText(next_hWnd, @buf, MAX_CHAR);
        if (buflen > 0) then
        begin
            Result := Result + CR +
                Format('%10d %s', [next_hWnd, String(buf)]);
        end;
        // Get the next child window.
        next_hWnd := GetWindow(next_hWnd, GW_HWNDNEXT);
    end;
end;

// ------------------------------------------------------
// TAWindowLister
// ------------------------------------------------------
// A do nothing constructor.
constructor TAWindowLister.Create;
begin

end;

end.
