unit MvcTabF;
//*******************************************************
// Form for the table view/controller for example program
// demonstrating the Model/View/Controller (MVC)
// paradigm.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls,
  MvcModel;

const
    NUM_COLORS = 13;
type
  TTableForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuClose: TMenuItem;
    procedure mnuCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ShowData;
    procedure FormCreate(Sender: TObject);
    procedure NameChanged(Sender: TObject);
    procedure ValueChanged(Sender: TObject);
    private
      { Private declarations }
      NameText  : array [1..100] of TEdit;
      ValueText : array [1..100] of TEdit;

    public
      { Public declarations }
      TheModel : TMvcModel;
      TheView  : TMvcView;
  end;

var
    TableForm: TTableForm;

implementation

{$R *.DFM}

procedure TTableForm.mnuCloseClick(Sender: TObject);
begin
    Close;
end;

procedure TTableForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    // Destroy the view.
    TheView.Free;

    Action := caFree;
end;

// Draw the data.
procedure TTableForm.ShowData;
var
    i : Integer;
begin
    for i := 1 to TheModel.NumValues do
    begin
        NameText[i].Text := TheModel.ExpenseName(i);
        ValueText[i].Text :=
            Format('%f', [TheModel.ExpenseValue(i)]);
    end;
end;

// Create TextBoxes to hold expense names and values.
procedure TTableForm.FormCreate(Sender: TObject);
var
    i, x, y : Integer;
begin
    x := 5;
    y := 5;
    for i := 1 to TheModel.NumValues do
    begin
        NameText[i] := TEdit.Create(Self);
        NameText[i].Width := 200;
        NameText[i].Top := y;
        NameText[i].Left := x;
        NameText[i].Parent := Self;
        NameText[i].OnChange := NameChanged;
        y := y + NameText[i].Height;
    end;

    x := NameText[1].Width + 10;
    y := 5;
    for i := 1 to TheModel.NumValues do
    begin
        ValueText[i] := TEdit.Create(Self);
        ValueText[i].Width := 60;
        ValueText[i].Left := x;
        ValueText[i].Top := y;
        ValueText[i].Parent := Self;
        ValueText[i].OnChange := ValueChanged;
        y := y + NameText[i].Height;
    end;
end;

// One of the name fields changed.
procedure TTableForm.NameChanged(Sender: TObject);
var
    i : Integer;
begin
    // Find the changed field.
    for i := 1 to TheModel.NumValues do
        if (NameText[i] = Sender) then break;
    if (i > TheModel.NumValues) then exit;

    // Report the change to the model.
    TheModel.SetExpenseName(i, NameText[i].Text, TheView);
end;

// One of the value fields changed.
procedure TTableForm.ValueChanged(Sender: TObject);
var
    i : Integer;
begin
    // Find the changed field.
    for i := 1 to TheModel.NumValues do
        if (ValueText[i] = Sender) then break;
    if (i > TheModel.NumValues) then exit;

    // Report the change to the model.
    TheModel.SetExpenseValue(i,
        StrToFloat(ValueText[i].Text), TheView);
end;

end.
