unit IterF;
//*******************************************************
// Example program demonstrating iterators and factory
// methods for a complete binary tree.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  IterTree;

type
  TIterForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    CmdCreate: TButton;
    CmdPreorder: TButton;
    Label1: TLabel;
    HeightText: TEdit;
    CmdInorder: TButton;
    CmdPostorder: TButton;
    CmdBreadthFirst: TButton;
    ResultLabel: TLabel;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure HeightTextChange(Sender: TObject);
    procedure CmdCreateClick(Sender: TObject);
    procedure Traverse(it_type : TIteratorType);
    procedure CmdPreorderClick(Sender: TObject);
    procedure CmdInorderClick(Sender: TObject);
    procedure CmdPostorderClick(Sender: TObject);
    procedure CmdBreadthFirstClick(Sender: TObject);
  private
    { Private declarations }
    TheTree : TCompleteTree;

  public
    { Public declarations }
  end;

var
  IterForm: TIterForm;

implementation

{$R *.DFM}

procedure TIterForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TIterForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin

    MessageDlg(
        'Niniejszy program demonstruje funkcjonowanie iteratorw w zastosowaniu do przechodzenia penego drzewa binarnego w rnych kolejnociach.' + CRCR +
        'Wprowad wysoko drzewa i kliknij w przycisk "Twrz drzewo", nastpnie kliknij w przycisk oznaczajcy dan kolejno przechodzenia.'
        , mtInformation, [mbOK], 0);




end;

// Create the root node.
procedure TIterForm.FormCreate(Sender: TObject);
begin
    // Create the tree.
    TheTree := TCompleteTree.Create;
    TheTree.MakeTree(1);
end;

// Make the tree draw itself.
procedure TIterForm.FormPaint(Sender: TObject);
begin
    TheTree.Draw(Canvas, CmdCreate.Left + CmdCreate.Width,
        HeightText.Top, ClientWidth, ClientHeight);
end;

// Disable the traversal buttons.
procedure TIterForm.HeightTextChange(Sender: TObject);
begin
    CmdCreate.Enabled := True;
    CmdPreorder.Enabled := False;
    CmdInorder.Enabled := False;
    CmdPostorder.Enabled := False;
    CmdBreadthFirst.Enabled := False;
end;

// Create the complete binary tree.
procedure TIterForm.CmdCreateClick(Sender: TObject);
begin
    TheTree.MakeTree(StrToInt(HeightText.Text));
    Refresh;

    // Enabled the traversal buttons.
    CmdCreate.Enabled := False;
    CmdPreorder.Enabled := True;
    CmdInorder.Enabled := True;
    CmdPostorder.Enabled := True;
    CmdBreadthFirst.Enabled := True;
    ResultLabel.Caption := '';
end;

// Display a traversal.
procedure TIterForm.Traverse(it_type : TIteratorType);
var
    trav : TIterator;
    txt  : String;
begin
    // Create the iterator using a factory method.
    trav := TheTree.CreateIterator(it_type);

    // Use the iterator to traverse the tree.
    txt := '';
    while (not trav.EndOfTree) do
    begin
        txt := txt + IntToStr(trav.CurrentNode) + ' ';
        trav.MoveNext;
    end;
    ResultLabel.Caption := txt;

    // Destroy the iterator.
    trav.Free;
end;

// Display the preorder traversal.
procedure TIterForm.CmdPreorderClick(Sender: TObject);
begin
    Traverse(itPreorder);
end;

// Display the inorder traversal.
procedure TIterForm.CmdInorderClick(Sender: TObject);
begin
    Traverse(itInorder);
end;

// Display the postorder traversal.
procedure TIterForm.CmdPostorderClick(Sender: TObject);
begin
    Traverse(itPostorder);
end;

// Display the breadth first traversal.
procedure TIterForm.CmdBreadthFirstClick(Sender: TObject);
begin
    Traverse(itBreadthFirst);
end;

end.
