unit Cmd1F;
//*******************************************************
// Example program demonstrating a generic user interface
// using command objects.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  Cmd1CmdC, Cmd1Beep, Cmd1Clr, Cmd1Size;

const
    NUM_BUTTONS = 6;

type
  TCmd1Form = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Button  : array[1..NUM_BUTTONS] of TButton;
    Command : array[1..NUM_BUTTONS] of TCommand;

    procedure ExecuteButton(Sender : TObject);

  public
    { Public declarations }
  end;

var
  Cmd1Form: TCmd1Form;

implementation

{$R *.DFM}

procedure TCmd1Form.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TCmd1Form.mnuAboutClick(Sender: TObject);
const
  CR = #13#10;
begin

    MessageDlg(
        'Niniejszy program demonstruje funcjonowanie obiektw-polece.' + CR +
        'Po klikniciu w przycisk nastpi wykonanie metody Execute() skojarzonego z tym przyciskiem obiektu'
        , mtInformation, [mbOK], 0);



end;

// Create the arrays of buttons and command objects.
procedure TCmd1Form.FormCreate(Sender: TObject);
begin
    // Beep button.
    Button[1] := TButton.Create(Self);
    Button[1].Parent := Self;
    Button[1].Top := 10;
    Button[1].Left := (ClientWidth - Button[1].Width) div 2;
    Button[1].Caption := 'Beep';
    Button[1].OnClick := ExecuteButton;
    Command[1] := TBeepCmd.Create;

    // Teal button.
    Button[2] := TButton.Create(Self);
    Button[2].Parent := Self;
    Button[2].Top := Button[1].Top + Button[1].Height + 10;
    Button[2].Left := Button[1].Left;
    Button[2].Caption := 'Teal';
    Button[2].OnClick := ExecuteButton;
    Command[2] := TColorCmd.Create;
    TColorCmd(Command[2]).Color := clTeal;

    // Aqua button.
    Button[3] := TButton.Create(Self);
    Button[3].Parent := Self;
    Button[3].Top := Button[2].Top + Button[2].Height + 10;
    Button[3].Left := Button[2].Left;
    Button[3].Caption := 'Aqua';
    Button[3].OnClick := ExecuteButton;
    Command[3] := TColorCmd.Create;
    TColorCmd(Command[3]).Color := clAqua;

    // Gray button.
    Button[4] := TButton.Create(Self);
    Button[4].Parent := Self;
    Button[4].Top := Button[3].Top + Button[3].Height + 10;
    Button[4].Left := Button[3].Left;
    Button[4].Caption := 'Gray';
    Button[4].OnClick := ExecuteButton;
    Command[4] := TColorCmd.Create;
    TColorCmd(Command[4]).Color := clGray;

    // Big button.
    Button[5] := TButton.Create(Self);
    Button[5].Parent := Self;
    Button[5].Top := Button[4].Top + Button[4].Height + 10;
    Button[5].Left := Button[4].Left;
    Button[5].Caption := 'Big Form';
    Button[5].OnClick := ExecuteButton;
    Command[5] := TSizeCmd.Create;
    TSizeCmd(Command[5]).Width := Width * 3;
    TSizeCmd(Command[5]).Height := Round(Height * 1.5);

    // Small button.
    Button[6] := TButton.Create(Self);
    Button[6].Parent := Self;
    Button[6].Top := Button[5].Top + Button[5].Height + 10;
    Button[6].Left := Button[5].Left;
    Button[6].Caption := 'Small Form';
    Button[6].OnClick := ExecuteButton;
    Command[6] := TSizeCmd.Create;
    TSizeCmd(Command[6]).Width := Width;
    TSizeCmd(Command[6]).Height := Height;
end;

// See which command was executed and fire the
// corresponding event.
procedure TCmd1Form.ExecuteButton(Sender : TObject);
var
    i : Integer;
begin
    for i := 1 to NUM_BUTTONS do
        if (Button[i] = Sender) then
        begin
            Command[i].Execute(Self);
            break;
        end;
end;

end.
