unit HeapQF;
//*******************************************************
// Example program demonstrating heap-based priority
// queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  HeapQC, Classes;

type
  THeapQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    Label1: TLabel;
    CmdPop: TButton;
    CmdPush: TButton;
    QueueLabel: TLabel;
    Label2: TLabel;
    PriorityText: TEdit;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
    procedure CmdPushClick(Sender: TObject);
    procedure CmdPopClick(Sender: TObject);
    procedure PriorityTextChange(Sender: TObject);
    procedure PriorityTextKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  HeapQForm: THeapQForm;

implementation

var
    the_queue : THeapQueue;

{$R *.DFM}

procedure THeapQForm.FormCreate(Sender: TObject);
begin
    // Make the queue.
    the_queue := THeapQueue.Create;
end;

procedure THeapQForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure THeapQForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin
    MessageDlg(
        'This program uses a heap to manage a priority queue.' + CRCR +
        'Enter a string and a priority and click the Enter button to add an item to the queue.' + CRCR +
        'Click the Leave button to remove the highest priority item from the queue.'
        , mtInformation, [mbOK], 0);


    MessageDlg(
        'Niniejszy program demonstruje funkcjonowanie kolejki priorytetowej' +CR +
        'w implementacji stogowej.' + CRCR +
        'Elementy o tym samym priorytecie umieszczane s w kolejce' +CR +
        'w kolejnoi wprowadzania.'
        , mtInformation, [mbOK], 0);





end;

procedure THeapQForm.ItemTextChange(Sender: TObject);
begin
    CmdPush.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
end;

procedure THeapQForm.CmdPushClick(Sender: TObject);
begin
    the_queue.Push(ItemText.Text, StrToInt(PriorityText.Text));
    QueueLabel.Caption := the_queue.TextValue;
    ItemText.Text := '';
    PriorityText.Text := '';
    ItemText.SetFocus;
    CmdPush.Enabled := False;
    CmdPop.Enabled := True;
end;

procedure THeapQForm.CmdPopClick(Sender: TObject);
begin
    ItemText.Text := the_queue.Pop;
    PriorityText.Text := '';
    ItemText.SetFocus;
    QueueLabel.Caption := the_queue.TextValue;
    CmdPush.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
    CmdPop.Enabled := (not the_queue.QueueEmpty);
end;

procedure THeapQForm.PriorityTextChange(Sender: TObject);
begin
    CmdPush.Enabled := ((ItemText.Text <> '') and
        (PriorityText.Text <> ''));
end;

procedure THeapQForm.PriorityTextKeyPress(Sender: TObject;
  var Key: Char);
begin
    if (Key = #8) then exit; // Backspace.
    if ((Key >= '0') and (Key <= '9')) then exit;
    Key := #0;
end;

end.
