unit TrSortF;
//*******************************************************
// Example program demonstrating sorted trees.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  TrSortTC, TrSortNC;

type
  TTrSortForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    CmdAdd: TButton;
    CmdRemove: TButton;
    Label1: TLabel;
    ValueText: TEdit;
    Label2: TLabel;
    NodesLabel: TLabel;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure CmdAddClick(Sender: TObject);
    procedure CmdRemoveClick(Sender: TObject);
    procedure ValueTextChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TrSortForm: TTrSortForm;

implementation

var
    tree   : TSortTree;
    x0, y0 : Integer;

{$R *.DFM}

procedure TTrSortForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TTrSortForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin

    MessageDlg(
        'Niniejszy program ilustruje funkcjonowanie posortowanego drzewa binarnego.' + CRCR +
        'Wprowad warto i kliknij przycisk "Wstaw", aby umieci w drzewie wze' + CR +
        'zawierajcy t warto' + CRCR +
        'Kliknij przycisk "Usu", aby usun wze zawierajcy podan warto'
       , mtInformation, [mbOK], 0);

end;

// Create the root node.
procedure TTrSortForm.FormCreate(Sender: TObject);
begin
    // Create an empty tree.
    tree := TSortTree.Create;

    // Save the coordinates where we will start drawing.
    x0 := 3;
    y0 := CmdAdd.Top + CmdAdd.Height + 3;

    // Use bold text.
    Canvas.Font.Style := [fsBold];
end;

// Draw the tree.
procedure TTrSortForm.FormPaint(Sender: TObject);
var
    rect : TRect;
begin
    // Erase the canvas.
    rect.Left := 0;
    rect.Right := Width;
    rect.Top := 0;
    rect.Bottom := Height;
    Canvas.Brush.Color := clLtGray;
    Canvas.FillRect(rect);

    // Draw the tree.
    tree.DrawTree(Canvas);
end;

// Add a value to the tree.
procedure TTrSortForm.CmdAddClick(Sender: TObject);
begin
    tree.Add(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TSortNode.NumAllocated);

    // Reposition the nodes.
    tree.SetPositions(x0, y0);
    Refresh;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

// Remove the indicated value from the tree.
procedure TTrSortForm.CmdRemoveClick(Sender: TObject);
begin
    // Remove the selected node from the tree.
    tree.Remove(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TSortNode.NumAllocated);

    // Reposition the remaining nodes.
    tree.SetPositions(x0, y0);
    Refresh;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

procedure TTrSortForm.ValueTextChange(Sender: TObject);
begin
    CmdAdd.Enabled := (ValueText.Text <> '');
    CmdRemove.Enabled := (CmdAdd.Enabled and tree.NotEmpty);
end;

// Destroy the tree and verify that all nodes have been
// destroyed.
procedure TTrSortForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    tree.Free;
    if (TSortNode.NumAllocated <> 0) then
        ShowMessage(Format(
            'Warning: %d nodes are still allocated.',
            [TSortNode.NumAllocated]));
end;

end.
